/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import org.aspectj.internal.tools.ant.taskdefs.ProductBuilder;
import org.aspectj.internal.tools.ant.taskdefs.ProjectMessager;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Builder;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Module;
import org.aspectj.internal.tools.build.Result;
import org.aspectj.internal.tools.build.Util;

public class AntBuilder
extends Builder {
    private static final boolean FORCE_FORK_FOR_LIBRARIES = false;
    private final Project project;

    public static Builder getBuilder(String config, Project project, File tempDir) {
        boolean useEclipseCompiles = false;
        boolean verbose = false;
        if (null != config) {
            if (-1 != config.indexOf("useEclipseCompiles")) {
                useEclipseCompiles = true;
            }
            if (-1 != config.indexOf("verbose")) {
                verbose = true;
            }
        }
        ProjectMessager handler = new ProjectMessager(project);
        ProductBuilder result = new ProductBuilder(project, tempDir, useEclipseCompiles, handler);
        if (verbose) {
            result.setVerbose(true);
        }
        return result;
    }

    private static String resultToTargetName(Result result) {
        return result.getName();
    }

    private static void makeTargetsForResult(Result result, Hashtable<String, Target> targets) {
        String resultTargetName = AntBuilder.resultToTargetName(result);
        Target target = targets.get(resultTargetName);
        if (null == target) {
            Result reqResult;
            int i;
            target = new Target();
            target.setName(resultTargetName);
            Result[] reqs = result.getRequired();
            StringBuffer depends = new StringBuffer();
            boolean first = true;
            for (i = 0; i < reqs.length; ++i) {
                reqResult = reqs[i];
                if (!first) {
                    depends.append(",");
                } else {
                    first = false;
                }
                depends.append(AntBuilder.resultToTargetName(reqResult));
            }
            if (0 < depends.length()) {
                target.setDepends(depends.toString());
            }
            targets.put(resultTargetName, target);
            for (i = 0; i < reqs.length; ++i) {
                reqResult = reqs[i];
                AntBuilder.makeTargetsForResult(reqResult, targets);
            }
        }
    }

    protected AntBuilder(Project project, File tempDir, boolean useEclipseCompiles, Messager handler) {
        super(tempDir, useEclipseCompiles, handler);
        this.project = project;
        Util.iaxIfNull(project, "project");
    }

    protected boolean setupTask(Task task, String name) {
        task.setProject(this.project);
        task.setTaskName("ajbuild-" + name);
        return true;
    }

    @Override
    protected boolean copyFile(File fromFile, File toFile, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.setFile(fromFile);
        copy.setTofile(toFile);
        this.executeTask((Task)copy);
        return true;
    }

    @Override
    protected boolean copyFiles(File fromDir, File toDir, String includes, String excludes, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.setTodir(toDir);
        FileSet fileset = new FileSet();
        fileset.setDir(fromDir);
        if (null != includes) {
            fileset.setIncludes(includes);
        }
        if (null != excludes) {
            fileset.setExcludes(excludes);
        }
        copy.addFileset(fileset);
        this.executeTask((Task)copy);
        return false;
    }

    protected void copyFileset(File toDir, FileSet fileSet, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.addFileset(fileSet);
        copy.setTodir(toDir);
        this.executeTask((Task)copy);
    }

    protected Copy makeCopyTask(boolean filter) {
        Copy copy = new Copy();
        this.setupTask((Task)copy, "copy");
        if (filter) {
            copy.setFiltering(true);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpMinFile(Result result, File classesDir, List<String> errors) {
        String name = result.getName() + "-empty";
        File minFile = new File(classesDir, name);
        FileWriter fw = null;
        try {
            fw = new FileWriter(minFile);
            fw.write(name);
        }
        catch (IOException e) {
            try {
                errors.add("IOException writing " + name + " to " + minFile + ": " + Util.renderException(e));
            }
            catch (Throwable throwable) {
                Util.close(fw);
                throw throwable;
            }
            Util.close(fw);
        }
        Util.close(fw);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean compile(Result result, File classesDir, boolean useExistingClasses, List<String> errors) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean setupClasspath(Result result, Path classpath) {
        boolean hasLibraries = false;
        for (File file : result.getLibJars()) {
            classpath.createPathElement().setLocation(file);
            if (hasLibraries) continue;
            hasLibraries = true;
        }
        Result[] reqs = result.getRequired();
        for (int i = 0; i < reqs.length; ++i) {
            Result requiredResult = reqs[i];
            classpath.createPathElement().setLocation(requiredResult.getOutputFile());
            if (!hasLibraries) {
                hasLibraries = true;
            }
            Iterator<File> iterator = requiredResult.getExportedLibJars().iterator();
            while (iterator.hasNext()) {
                classpath.createPathElement().setLocation(iterator.next());
            }
        }
        return hasLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean assemble(Result result, File classesDir, List<String> errors) {
        if (!this.buildingEnabled) {
            return false;
        }
        if (!result.outOfDate()) {
            return true;
        }
        Zip zip = new Zip();
        this.setupTask((Task)zip, "zip");
        zip.setDestFile(result.getOutputFile());
        ZipFileSet zipfileset = null;
        for (File srcDir : result.getSrcDirs()) {
            zipfileset = new ZipFileSet();
            zipfileset.setProject(this.project);
            zipfileset.setDir(srcDir);
            zipfileset.setIncludes(RESOURCE_PATTERN);
            zip.addZipfileset(zipfileset);
        }
        Module module = result.getModule();
        File metaInfDir = new File(classesDir, "META-INF");
        Util.deleteContents(metaInfDir);
        File manifest = new File(module.moduleDir, module.name + ".mf.txt");
        if (Util.canReadFile(manifest)) {
            if (Util.canReadDir(metaInfDir) || metaInfDir.mkdirs()) {
                this.copyFile(manifest, new File(metaInfDir, "MANIFEST.MF"), true);
            } else {
                errors.add("have manifest, but unable to create " + metaInfDir);
                return false;
            }
        }
        zipfileset = new ZipFileSet();
        zipfileset.setProject(this.project);
        zipfileset.setDir(classesDir);
        zipfileset.setIncludes("**/*");
        zip.addZipfileset(zipfileset);
        File[] contents = classesDir.listFiles();
        if (null == contents || 0 == contents.length) {
            this.dumpMinFile(result, classesDir, errors);
        }
        try {
            this.handler.log("assemble " + module + " in " + result.getOutputFile());
            boolean bl = this.executeTask((Task)zip) && Util.canReadFile(result.getOutputFile());
            return bl;
        }
        catch (BuildException e) {
            errors.add("BuildException zipping " + module + ": " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            result.clearOutOfDate();
        }
    }

    @Override
    protected Result[] getAntecedantResults(Result moduleResult) {
        Hashtable<String, Target> targets = new Hashtable<String, Target>();
        AntBuilder.makeTargetsForResult(moduleResult, targets);
        String targetName = AntBuilder.resultToTargetName(moduleResult);
        Vector result = this.project.topoSort(targetName, targets);
        int size = result.size();
        if (0 == result.size()) {
            return new Result[0];
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Target target : result) {
            String name = target.getName();
            if (null == name) {
                throw new Error("null name?");
            }
            toReturn.add(name);
        }
        if (1 == size && targetName.equals(toReturn.get(0)) && !moduleResult.outOfDate()) {
            return new Result[0];
        }
        return Result.getResults(toReturn.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean assembleAll(Result result, Messager handler) {
        if (!this.buildingEnabled) {
            return false;
        }
        if (!result.outOfDate()) {
            return true;
        }
        Util.iaxIfNull(result, "result");
        Util.iaxIfNull(handler, "handler");
        if (!result.getKind().isAssembly()) {
            throw new IllegalStateException("not assembly: " + result);
        }
        Zip zip = new Zip();
        this.setupTask((Task)zip, "zip");
        zip.setDestFile(result.getOutputFile());
        ZipFileSet zipfileset = null;
        Module module = result.getModule();
        List<File> known = result.findJarRequirements();
        this.removeLibraryFilesToSkip(module, known);
        for (File jarFile : known) {
            zipfileset = new ZipFileSet();
            zipfileset.setProject(this.project);
            zipfileset.setSrc(jarFile);
            zipfileset.setIncludes("**/*");
            String name = jarFile.getName();
            name = name.substring(0, name.length() - 4);
            if (!module.name.equals(name)) {
                zipfileset.setExcludes("META-INF/MANIFEST.MF");
                zipfileset.setExcludes("META-INF/manifest.mf");
                zipfileset.setExcludes("meta-inf/manifest.mf");
                zipfileset.setExcludes("meta-inf/MANIFEST.MF");
            }
            zip.addZipfileset(zipfileset);
        }
        try {
            handler.log("assembling all " + module + " in " + result.getOutputFile());
            if (this.verbose) {
                handler.log("knownAntecedants: " + known);
            }
            boolean bl = this.executeTask((Task)zip);
            return bl;
        }
        catch (BuildException e) {
            handler.logException("BuildException zipping " + module, e);
            boolean bl = false;
            return bl;
        }
        finally {
            result.clearOutOfDate();
        }
    }

    @Override
    protected boolean buildInstaller(BuildSpec buildSpec, String targDirPath) {
        return false;
    }

    protected boolean executeTask(Task task) {
        if (!this.buildingEnabled) {
            return false;
        }
        task.execute();
        return true;
    }

    static class AspectJSupport {
        static final String AJCTASK = "org.aspectj.tools.ant.taskdefs.AjcTask";
        static final String ASPECTJRT_JAR_VARIABLE = "ASPECTJRT_LIB";
        static final String LIBASPECTJ_RPATH = "/lib/aspectj";
        static final Map nameToAspectjrtjar = new HashMap();
        static final String NONE = "NONE";

        static Task wrapIfNeeded(Result result, Javac javac) {
            Project project = javac.getProject();
            Path runtimeJar = null;
            Module module = result.getModule();
            if (!AspectJSupport.runtimeJarOnClasspath(result)) {
                if (result.getClasspathVariables().contains(ASPECTJRT_JAR_VARIABLE)) {
                    runtimeJar = AspectJSupport.getAspectJLib(project, module, "aspectjrt.jar");
                } else {
                    return javac;
                }
            }
            Path aspectjtoolsJar = AspectJSupport.getAspectJLib(project, module, "aspectjtools.jar");
            return AspectJSupport.aspectJTask(javac, aspectjtoolsJar, runtimeJar);
        }

        private static boolean runtimeJarOnClasspath(Result result) {
            for (File file : result.getLibJars()) {
                if (!"aspectjrt.jar".equals(file.getName())) continue;
                return true;
            }
            return false;
        }

        static Path getAspectJLib(Project project, Module module, String name) {
            Path result = null;
            String[] libDirNames = new String[]{"aspectj.home", "ASPECTJ_HOME", LIBASPECTJ_RPATH};
            String[] libDirs = new String[libDirNames.length];
            for (int i = 0; i < libDirNames.length; ++i) {
                libDirs[i] = LIBASPECTJ_RPATH == libDirNames[i] ? module.getFullPath(LIBASPECTJ_RPATH) : project.getProperty(libDirNames[i]);
                if (null == libDirs[i]) continue;
                libDirs[i] = Util.path(libDirs[i], "lib");
                result = new Path(project, Util.path(libDirs[i], name));
                String path = result.toString();
                if (!new File(path).canRead()) continue;
                return result;
            }
            String m = "unable to find " + name + " in " + Arrays.asList(libDirs);
            throw new BuildException(m);
        }

        static Task aspectJTask(Javac javac, Path toolsJar, Path runtimeJar) {
            Object task = null;
            String url = null;
            try {
                url = "file:" + toolsJar.toString().replace('\\', '/');
                URL[] cp = new URL[]{new URL(url)};
                ClassLoader parent = Task.class.getClassLoader();
                URLClassLoader loader = new URLClassLoader(cp, parent);
                Class<?> c = loader.loadClass(AJCTASK);
                task = c.newInstance();
                Method m = c.getMethod("setupAjc", Javac.class);
                m.invoke(task, javac);
                m = c.getMethod("setFork", Boolean.TYPE);
                m.invoke(task, Boolean.TRUE);
                m = c.getMethod("setForkclasspath", Path.class);
                m.invoke(task, toolsJar);
                m = c.getMethod("setSourceRoots", Path.class);
                m.invoke(task, javac.getSrcdir());
                if (null != runtimeJar) {
                    m = c.getMethod("setClasspath", Path.class);
                    m.invoke(task, runtimeJar);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Throwable t) {
                StringBuffer sb = new StringBuffer();
                sb.append("classpath=");
                sb.append(url);
                throw new BuildException(sb.toString(), t);
            }
            return task;
        }

        private AspectJSupport() {
            throw new Error("no instances");
        }
    }
}

