#ifndef ATL_dGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,180,240,300,360,540,780,840,960,1140,1320,1440,1560
 * N : 25,180,240,300,360,540,780,840,960,1140,1320,1440,1560
 * NB : 2,12,12,12,24,24,36,36,60,60,60,60,120
 */
#define ATL_dGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 102) (nb_) = 2; \
   else if ((n_) < 330) (nb_) = 12; \
   else if ((n_) < 660) (nb_) = 24; \
   else if ((n_) < 900) (nb_) = 36; \
   else if ((n_) < 1500) (nb_) = 60; \
   else (nb_) = 120; \
}


#endif    /* end ifndef ATL_dGetNB_geqrf */
