// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include <grpc/support/port_platform.h>

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_8_12_10.h"
namespace grpc_core {
namespace geometry_8_12_10 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[74] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint16_t HuffDecoderCommon::table1_0_inner_[76] = {
    0x0005, 0x0045, 0x0085, 0x00c5, 0x0105, 0x0145, 0x0185, 0x01c5, 0x0205,
    0x0245, 0x0286, 0x02c6, 0x0306, 0x0346, 0x0386, 0x03c6, 0x0406, 0x0446,
    0x0486, 0x04c6, 0x0506, 0x0546, 0x0586, 0x05c6, 0x0606, 0x0646, 0x0686,
    0x06c6, 0x0706, 0x0746, 0x0786, 0x07c6, 0x0806, 0x0846, 0x0886, 0x08c6,
    0x0907, 0x0947, 0x0987, 0x09c7, 0x0a07, 0x0a47, 0x0a87, 0x0ac7, 0x0b07,
    0x0b47, 0x0b87, 0x0bc7, 0x0c07, 0x0c47, 0x0c87, 0x0cc7, 0x0d07, 0x0d47,
    0x0d87, 0x0dc7, 0x0e07, 0x0e47, 0x0e87, 0x0ec7, 0x0f07, 0x0f47, 0x0f87,
    0x0fc7, 0x1007, 0x1047, 0x1087, 0x10c7, 0x1108, 0x1148, 0x1188, 0x11c8,
    0x1208, 0x1248, 0x0018, 0x0028};
const uint8_t HuffDecoderCommon::table1_0_outer_[256] = {
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
    2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,
    4,  4,  5,  5,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  6,  6,  7,
    7,  7,  7,  7,  7,  7,  7,  8,  8,  8,  8,  8,  8,  8,  8,  9,  9,  9,  9,
    9,  9,  9,  9,  10, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13,
    13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18,
    18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23,
    23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
    28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32,
    32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35, 36, 36, 37, 37, 38, 38,
    39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48,
    48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57,
    58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67,
    67, 68, 69, 70, 71, 72, 73, 74, 75};
const uint8_t HuffDecoderCommon::table8_0_inner_[6] = {0x00, 0x01, 0x05,
                                                       0x09, 0x0d, 0x02};
const uint8_t HuffDecoderCommon::table8_0_outer_[8] = {0, 1, 2, 3, 4, 0, 0, 5};
const uint8_t HuffDecoderCommon::table9_0_emit_[6] = {0x3f, 0x27, 0x2b,
                                                      0x7c, 0x23, 0x3e};
const uint8_t HuffDecoderCommon::table9_0_inner_[8] = {0x00, 0x01, 0x05, 0x09,
                                                       0x0d, 0x11, 0x15, 0x02};
const uint8_t HuffDecoderCommon::table9_0_outer_[16] = {0, 0, 0, 1, 0, 2, 0, 3,
                                                        0, 4, 5, 6, 0, 0, 0, 7};
const uint8_t HuffDecoderCommon::table10_0_emit_[12] = {
    0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table10_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11,
    0x00, 0x15, 0x19, 0x1d, 0x21, 0x25, 0x29, 0x2d, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table11_0_emit_[14] = {
    0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e, 0x00,
    0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table11_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00,
    0x25, 0x00, 0x29, 0x00, 0x2d, 0x31, 0x35, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table12_0_emit_[36] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f, 0x65,
    0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x27, 0x2b, 0x7c, 0x23,
    0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table12_0_ops_[128] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x5e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x62,
    0x01, 0x01, 0x01, 0x66, 0x01, 0x01, 0x01, 0x6a, 0x01, 0x01, 0x01, 0x6e,
    0x01, 0x01, 0x01, 0x72, 0x01, 0x01, 0x01, 0x76, 0x01, 0x01, 0x01, 0x7a,
    0x01, 0x7e, 0x01, 0x82, 0x86, 0x8a, 0x8e, 0x03};
const uint8_t HuffDecoderCommon::table13_0_emit_[44] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f,
    0x65, 0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20,
    0x3f, 0x25, 0x3f, 0x2d, 0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f,
    0x34, 0x3f, 0x35, 0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table13_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x51, 0x59,
    0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9};
const uint8_t HuffDecoderCommon::table13_1_emit_[28] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64,
    0x3f, 0x66, 0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d,
    0x3f, 0x6e, 0x3f, 0x70, 0x3f, 0x72, 0x3f, 0x75};
const uint8_t HuffDecoderCommon::table13_1_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table13_2_emit_[20] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63,
    0x27, 0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74};
const uint8_t HuffDecoderCommon::table13_2_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table13_3_emit_[20] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63,
    0x2b, 0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74};
const uint8_t HuffDecoderCommon::table13_4_emit_[20] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63,
    0x7c, 0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74};
const uint8_t HuffDecoderCommon::table13_5_emit_[2] = {0x23, 0x3e};
const uint8_t HuffDecoderCommon::table13_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06};
const uint8_t HuffDecoderCommon::table13_6_emit_[4] = {0x00, 0x24, 0x40, 0x5b};
const uint8_t HuffDecoderCommon::table13_6_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e};
const uint8_t HuffDecoderCommon::table13_7_emit_[7] = {0x5d, 0x7e, 0x5e, 0x7d,
                                                       0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table13_7_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x12, 0x00, 0x16, 0x00, 0x1a, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table13_emit_[8] = {
    table13_0_emit_, table13_1_emit_, table13_2_emit_, table13_3_emit_,
    table13_4_emit_, table13_5_emit_, table13_6_emit_, table13_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table13_ops_[8] = {
    table13_0_ops_, table13_1_ops_, table13_2_ops_, table13_2_ops_,
    table13_2_ops_, table13_5_ops_, table13_6_ops_, table13_7_ops_,
};
const uint8_t HuffDecoderCommon::table14_0_emit_[16] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61,
    0x3f, 0x63, 0x3f, 0x65, 0x3f, 0x69, 0x3f, 0x6f};
const uint8_t HuffDecoderCommon::table14_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
    0x11, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00,
    0x00, 0x29, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x39};
const uint8_t HuffDecoderCommon::table14_1_emit_[28] = {
    0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25, 0x3f, 0x2d,
    0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table14_1_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x11, 0x00,
    0x19, 0x00, 0x21, 0x00, 0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41,
    0x00, 0x49, 0x00, 0x51, 0x00, 0x59, 0x00, 0x61, 0x00, 0x69};
const uint8_t HuffDecoderCommon::table14_2_emit_[36] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64, 0x3f, 0x66,
    0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70,
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint8_t HuffDecoderCommon::table14_2_ops_[32] = {
    0x00, 0x01, 0x00, 0x09, 0x00, 0x11, 0x00, 0x19, 0x00, 0x21, 0x00,
    0x29, 0x00, 0x31, 0x00, 0x39, 0x00, 0x41, 0x00, 0x49, 0x00, 0x51,
    0x00, 0x59, 0x00, 0x61, 0x00, 0x69, 0x71, 0x79, 0x81, 0x89};
const uint8_t HuffDecoderCommon::table14_3_emit_[56] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a};
const uint8_t HuffDecoderCommon::table14_3_ops_[32] = {
    0x01, 0x09, 0x11, 0x19, 0x21, 0x29, 0x31, 0x39, 0x41, 0x49, 0x51,
    0x59, 0x61, 0x69, 0x71, 0x79, 0x81, 0x89, 0x91, 0x99, 0xa1, 0xa9,
    0xb1, 0xb9, 0xc1, 0xc9, 0xd1, 0xd9, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table14_4_emit_[44] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63, 0x27,
    0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74, 0x27, 0x20,
    0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27,
    0x34, 0x27, 0x35, 0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table14_5_emit_[28] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64,
    0x27, 0x66, 0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d,
    0x27, 0x6e, 0x27, 0x70, 0x27, 0x72, 0x27, 0x75};
const uint8_t HuffDecoderCommon::table14_6_emit_[44] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63, 0x2b,
    0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20,
    0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b,
    0x34, 0x2b, 0x35, 0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table14_7_emit_[28] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64,
    0x2b, 0x66, 0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d,
    0x2b, 0x6e, 0x2b, 0x70, 0x2b, 0x72, 0x2b, 0x75};
const uint8_t HuffDecoderCommon::table14_8_emit_[44] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20,
    0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c,
    0x34, 0x7c, 0x35, 0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table14_9_emit_[28] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64,
    0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d,
    0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72, 0x7c, 0x75};
const uint8_t HuffDecoderCommon::table14_10_emit_[20] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63,
    0x23, 0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74};
const uint8_t HuffDecoderCommon::table14_11_emit_[20] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63,
    0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74};
const uint8_t HuffDecoderCommon::table14_12_emit_[2] = {0x00, 0x24};
const uint8_t HuffDecoderCommon::table14_13_emit_[2] = {0x40, 0x5b};
const uint8_t HuffDecoderCommon::table14_14_emit_[2] = {0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table14_15_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                        0x7b};
const uint8_t HuffDecoderCommon::table14_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00,
    0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x03};
const uint8_t* const HuffDecoderCommon::table14_emit_[16] = {
    table14_0_emit_,  table14_1_emit_,  table14_2_emit_,  table14_3_emit_,
    table14_4_emit_,  table14_5_emit_,  table14_6_emit_,  table14_7_emit_,
    table14_8_emit_,  table14_9_emit_,  table14_10_emit_, table14_11_emit_,
    table14_12_emit_, table14_13_emit_, table14_14_emit_, table14_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table14_ops_[16] = {
    table14_0_ops_, table14_1_ops_, table14_2_ops_, table14_3_ops_,
    table13_0_ops_, table13_1_ops_, table13_0_ops_, table13_1_ops_,
    table13_0_ops_, table13_1_ops_, table13_2_ops_, table13_2_ops_,
    table13_5_ops_, table13_5_ops_, table13_5_ops_, table14_15_ops_,
};
const uint16_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint16_t HuffDecoderCommon::table15_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint16_t HuffDecoderCommon::table15_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table15_3_emit_[68] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26, 0x3f, 0x2a,
    0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a};
const uint16_t HuffDecoderCommon::table15_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint16_t HuffDecoderCommon::table15_4_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table15_5_emit_[92] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44,
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a};
const uint16_t HuffDecoderCommon::table15_5_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table15_7_emit_[92] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44,
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a};
const uint8_t HuffDecoderCommon::table15_9_emit_[92] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a};
const uint8_t HuffDecoderCommon::table15_10_emit_[72] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75};
const uint16_t HuffDecoderCommon::table15_10_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table15_11_emit_[72] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75};
const uint8_t HuffDecoderCommon::table15_12_emit_[40] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63,
    0x24, 0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74};
const uint16_t HuffDecoderCommon::table15_12_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table15_13_emit_[40] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63,
    0x40, 0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63,
    0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74};
const uint8_t HuffDecoderCommon::table15_14_emit_[40] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63,
    0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63,
    0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74};
const uint16_t HuffDecoderCommon::table15_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table15_emit_[16] = {
    table14_0_emit_,  table14_1_emit_,  table14_2_emit_,  table15_3_emit_,
    table14_4_emit_,  table15_5_emit_,  table14_6_emit_,  table15_7_emit_,
    table14_8_emit_,  table15_9_emit_,  table15_10_emit_, table15_11_emit_,
    table15_12_emit_, table15_13_emit_, table15_14_emit_, table14_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table15_ops_[16] = {
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_4_ops_,  table15_5_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_10_ops_, table15_10_ops_,
    table15_12_ops_, table15_12_ops_, table15_12_ops_, table15_15_ops_,
};
const uint8_t HuffDecoderCommon::table16_0_emit_[8] = {0x3f, 0x30, 0x3f, 0x31,
                                                       0x3f, 0x32, 0x3f, 0x61};
const uint16_t HuffDecoderCommon::table16_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019};
const uint8_t HuffDecoderCommon::table16_1_emit_[8] = {0x3f, 0x63, 0x3f, 0x65,
                                                       0x3f, 0x69, 0x3f, 0x6f};
const uint8_t HuffDecoderCommon::table16_2_emit_[12] = {
    0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25, 0x3f, 0x2d, 0x3f, 0x2e};
const uint16_t HuffDecoderCommon::table16_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029};
const uint8_t HuffDecoderCommon::table16_3_emit_[16] = {
    0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table16_4_emit_[16] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62,
    0x3f, 0x64, 0x3f, 0x66, 0x3f, 0x67, 0x3f, 0x68};
const uint8_t HuffDecoderCommon::table16_5_emit_[20] = {
    0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70, 0x3f, 0x72,
    0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint16_t HuffDecoderCommon::table16_5_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049};
const uint8_t HuffDecoderCommon::table16_6_emit_[32] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f,
    0x4a, 0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f,
    0x3f, 0x50, 0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54};
const uint16_t HuffDecoderCommon::table16_6_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000, 0x0079};
const uint8_t HuffDecoderCommon::table16_7_emit_[36] = {
    0x3f, 0x55, 0x3f, 0x56, 0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b,
    0x3f, 0x71, 0x3f, 0x76, 0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a,
    0x3f, 0x26, 0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a};
const uint16_t HuffDecoderCommon::table16_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table16_8_emit_[16] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61,
    0x27, 0x63, 0x27, 0x65, 0x27, 0x69, 0x27, 0x6f};
const uint8_t HuffDecoderCommon::table16_9_emit_[28] = {
    0x27, 0x73, 0x27, 0x74, 0x27, 0x20, 0x27, 0x25, 0x27, 0x2d,
    0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27, 0x34, 0x27, 0x35,
    0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table16_10_emit_[36] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint8_t HuffDecoderCommon::table16_11_emit_[68] = {
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a, 0x27, 0x26, 0x27, 0x2a,
    0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a};
const uint8_t HuffDecoderCommon::table16_12_emit_[16] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61,
    0x2b, 0x63, 0x2b, 0x65, 0x2b, 0x69, 0x2b, 0x6f};
const uint8_t HuffDecoderCommon::table16_13_emit_[28] = {
    0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20, 0x2b, 0x25, 0x2b, 0x2d,
    0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b, 0x34, 0x2b, 0x35,
    0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table16_14_emit_[36] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table16_15_emit_[68] = {
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a, 0x2b, 0x26, 0x2b, 0x2a,
    0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a};
const uint8_t HuffDecoderCommon::table16_16_emit_[16] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61,
    0x7c, 0x63, 0x7c, 0x65, 0x7c, 0x69, 0x7c, 0x6f};
const uint8_t HuffDecoderCommon::table16_17_emit_[28] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d,
    0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table16_18_emit_[36] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table16_19_emit_[68] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26, 0x7c, 0x2a,
    0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint8_t HuffDecoderCommon::table16_20_emit_[44] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23,
    0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20,
    0x23, 0x25, 0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23,
    0x34, 0x23, 0x35, 0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint8_t HuffDecoderCommon::table16_21_emit_[92] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44,
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a};
const uint8_t HuffDecoderCommon::table16_22_emit_[44] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e,
    0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20,
    0x3e, 0x25, 0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e,
    0x34, 0x3e, 0x35, 0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table16_23_emit_[92] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44,
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a};
const uint8_t HuffDecoderCommon::table16_24_emit_[72] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00, 0x65,
    0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20, 0x00, 0x25,
    0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41,
    0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66, 0x00, 0x67, 0x00, 0x68,
    0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70, 0x00, 0x72, 0x00, 0x75};
const uint8_t HuffDecoderCommon::table16_25_emit_[72] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24, 0x65,
    0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20, 0x24, 0x25,
    0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39, 0x24, 0x3d, 0x24, 0x41,
    0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66, 0x24, 0x67, 0x24, 0x68,
    0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70, 0x24, 0x72, 0x24, 0x75};
const uint8_t HuffDecoderCommon::table16_26_emit_[72] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40, 0x65,
    0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20, 0x40, 0x25,
    0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39, 0x40, 0x3d, 0x40, 0x41,
    0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66, 0x40, 0x67, 0x40, 0x68,
    0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70, 0x40, 0x72, 0x40, 0x75};
const uint8_t HuffDecoderCommon::table16_27_emit_[72] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b, 0x65,
    0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20, 0x5b, 0x25,
    0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39, 0x5b, 0x3d, 0x5b, 0x41,
    0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66, 0x5b, 0x67, 0x5b, 0x68,
    0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70, 0x5b, 0x72, 0x5b, 0x75};
const uint8_t HuffDecoderCommon::table16_28_emit_[72] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25,
    0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39, 0x5d, 0x3d, 0x5d, 0x41,
    0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68,
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72, 0x5d, 0x75};
const uint8_t HuffDecoderCommon::table16_29_emit_[72] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65,
    0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25,
    0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39, 0x7e, 0x3d, 0x7e, 0x41,
    0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68,
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72, 0x7e, 0x75};
const uint8_t HuffDecoderCommon::table16_30_emit_[40] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63,
    0x5e, 0x65, 0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74,
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63,
    0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74};
const uint8_t HuffDecoderCommon::table16_31_emit_[6] = {0x3c, 0x60, 0x7b,
                                                        0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table16_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x000e, 0x0012, 0x0016, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table16_emit_[32] = {
    table16_0_emit_,  table16_1_emit_,  table16_2_emit_,  table16_3_emit_,
    table16_4_emit_,  table16_5_emit_,  table16_6_emit_,  table16_7_emit_,
    table16_8_emit_,  table16_9_emit_,  table16_10_emit_, table16_11_emit_,
    table16_12_emit_, table16_13_emit_, table16_14_emit_, table16_15_emit_,
    table16_16_emit_, table16_17_emit_, table16_18_emit_, table16_19_emit_,
    table16_20_emit_, table16_21_emit_, table16_22_emit_, table16_23_emit_,
    table16_24_emit_, table16_25_emit_, table16_26_emit_, table16_27_emit_,
    table16_28_emit_, table16_29_emit_, table16_30_emit_, table16_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table16_ops_[32] = {
    table16_0_ops_,  table16_0_ops_,  table16_2_ops_,  table15_0_ops_,
    table15_0_ops_,  table16_5_ops_,  table16_6_ops_,  table16_7_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_0_ops_,  table15_1_ops_,  table15_2_ops_,  table15_3_ops_,
    table15_4_ops_,  table15_5_ops_,  table15_4_ops_,  table15_5_ops_,
    table15_10_ops_, table15_10_ops_, table15_10_ops_, table15_10_ops_,
    table15_10_ops_, table15_10_ops_, table15_12_ops_, table16_31_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[1] = {0x3f};
const uint16_t HuffDecoderCommon::table6_0_ops_[128] = {
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002,
    0x0002, 0x0002};
const uint8_t HuffDecoderCommon::table6_8_emit_[1] = {0x27};
const uint16_t HuffDecoderCommon::table6_8_ops_[128] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table6_12_emit_[1] = {0x2b};
const uint8_t HuffDecoderCommon::table6_16_emit_[1] = {0x7c};
const uint8_t HuffDecoderCommon::table6_20_emit_[1] = {0x23};
const uint16_t HuffDecoderCommon::table6_20_ops_[128] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table6_22_emit_[1] = {0x3e};
const uint8_t HuffDecoderCommon::table6_24_emit_[1] = {0x00};
const uint16_t HuffDecoderCommon::table6_24_ops_[128] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table6_25_emit_[1] = {0x24};
const uint8_t HuffDecoderCommon::table6_26_emit_[1] = {0x40};
const uint8_t HuffDecoderCommon::table6_27_emit_[1] = {0x5b};
const uint8_t HuffDecoderCommon::table6_28_emit_[1] = {0x5d};
const uint8_t HuffDecoderCommon::table6_29_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table6_30_emit_[2] = {0x5e, 0x7d};
const uint16_t HuffDecoderCommon::table6_30_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206, 0x0206,
    0x0206, 0x0206};
const uint8_t HuffDecoderCommon::table6_31_emit_[14] = {
    0x3c, 0x60, 0x7b, 0x5c, 0xc3, 0xd0, 0x80,
    0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint16_t HuffDecoderCommon::table6_31_ops_[128] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0207, 0x0207, 0x0207, 0x0207,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207,
    0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207, 0x0207,
    0x0207, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
    0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
    0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
    0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x060b, 0x060b, 0x080b,
    0x080b, 0x0a0b, 0x0a0b, 0x0c0c, 0x0e0c, 0x100c, 0x120c, 0x140c, 0x160c,
    0x180c, 0x1a0c, 0x001c, 0x002c, 0x003c, 0x004c, 0x005c, 0x006c, 0x007c,
    0x008c, 0x009c, 0x00ac, 0x00bc, 0x00cc, 0x00dc, 0x00ec, 0x00fc, 0x010c,
    0x011c, 0x012c};
const uint8_t* const HuffDecoderCommon::table6_emit_[32] = {
    table6_0_emit_,  table6_0_emit_,  table6_0_emit_,  table6_0_emit_,
    table6_0_emit_,  table6_0_emit_,  table6_0_emit_,  table6_0_emit_,
    table6_8_emit_,  table6_8_emit_,  table6_8_emit_,  table6_8_emit_,
    table6_12_emit_, table6_12_emit_, table6_12_emit_, table6_12_emit_,
    table6_16_emit_, table6_16_emit_, table6_16_emit_, table6_16_emit_,
    table6_20_emit_, table6_20_emit_, table6_22_emit_, table6_22_emit_,
    table6_24_emit_, table6_25_emit_, table6_26_emit_, table6_27_emit_,
    table6_28_emit_, table6_29_emit_, table6_30_emit_, table6_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table6_ops_[32] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_8_ops_,  table6_8_ops_,  table6_8_ops_,  table6_8_ops_,
    table6_8_ops_,  table6_8_ops_,  table6_8_ops_,  table6_8_ops_,
    table6_8_ops_,  table6_8_ops_,  table6_8_ops_,  table6_8_ops_,
    table6_20_ops_, table6_20_ops_, table6_20_ops_, table6_20_ops_,
    table6_24_ops_, table6_24_ops_, table6_24_ops_, table6_24_ops_,
    table6_24_ops_, table6_24_ops_, table6_30_ops_, table6_31_ops_,
};
const uint8_t HuffDecoderCommon::table29_0_emit_[8] = {0x01, 0x87, 0x89, 0x8a,
                                                       0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table29_0_inner_[8] = {0x03, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b, 0x1f};
const uint8_t HuffDecoderCommon::table30_0_emit_[8] = {0x93, 0x95, 0x96, 0x97,
                                                       0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table31_0_emit_[8] = {0xa5, 0xa6, 0xa8, 0xae,
                                                       0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table35_0_emit_[5] = {0xbc, 0xbf, 0xc5, 0xe7,
                                                       0xef};
const uint8_t HuffDecoderCommon::table35_0_inner_[6] = {0x00, 0x02, 0x04,
                                                        0x06, 0x08, 0x01};
const uint8_t HuffDecoderCommon::table34_0_emit_[11] = {
    0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table34_0_inner_[11] = {
    0x03, 0x0b, 0x13, 0x1b, 0x23, 0x2c, 0x34, 0x3c, 0x44, 0x4c, 0x54};
const uint8_t HuffDecoderCommon::table37_0_emit_[6] = {0xab, 0xce, 0xd7,
                                                       0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table37_0_inner_[8] = {0x00, 0x04, 0x08, 0x0c,
                                                        0x10, 0x14, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table38_0_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table38_0_ops_[32] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x19, 0x1d, 0x21, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table39_0_emit_[25] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea,
    0xeb, 0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table39_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29,
    0x2d, 0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55,
    0x59, 0x5d, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table40_0_emit_[44] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb, 0xc0,
    0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf,
    0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table40_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x35,
    0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d,
    0x00, 0x51, 0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x65, 0x69,
    0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99,
    0x9d, 0xa1, 0xa5, 0xa9, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table41_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25};
const uint8_t HuffDecoderCommon::table41_1_emit_[63] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee,
    0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde,
    0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd,
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table41_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51,
    0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69,
    0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81,
    0x00, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1, 0xa5, 0xa9, 0xad,
    0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0xd1, 0xd5, 0xd9, 0xdd,
    0xe1, 0xe5, 0xe9, 0xed, 0xf1, 0xf5, 0xf9, 0x02};
const uint8_t* const HuffDecoderCommon::table41_emit_[2] = {
    table38_0_emit_,
    table41_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table41_ops_[2] = {
    table41_0_ops_,
    table41_1_ops_,
};
const uint8_t HuffDecoderCommon::table42_0_emit_[40] = {
    0xab, 0x30, 0xab, 0x31, 0xab, 0x32, 0xab, 0x61, 0xab, 0x63,
    0xab, 0x65, 0xab, 0x69, 0xab, 0x6f, 0xab, 0x73, 0xab, 0x74,
    0xce, 0x30, 0xce, 0x31, 0xce, 0x32, 0xce, 0x61, 0xce, 0x63,
    0xce, 0x65, 0xce, 0x69, 0xce, 0x6f, 0xce, 0x73, 0xce, 0x74};
const uint8_t HuffDecoderCommon::table42_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50,
    0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52};
const uint8_t HuffDecoderCommon::table42_1_emit_[40] = {
    0xd7, 0x30, 0xd7, 0x31, 0xd7, 0x32, 0xd7, 0x61, 0xd7, 0x63,
    0xd7, 0x65, 0xd7, 0x69, 0xd7, 0x6f, 0xd7, 0x73, 0xd7, 0x74,
    0xe1, 0x30, 0xe1, 0x31, 0xe1, 0x32, 0xe1, 0x61, 0xe1, 0x63,
    0xe1, 0x65, 0xe1, 0x69, 0xe1, 0x6f, 0xe1, 0x73, 0xe1, 0x74};
const uint8_t HuffDecoderCommon::table42_2_emit_[40] = {
    0xec, 0x30, 0xec, 0x31, 0xec, 0x32, 0xec, 0x61, 0xec, 0x63,
    0xec, 0x65, 0xec, 0x69, 0xec, 0x6f, 0xec, 0x73, 0xec, 0x74,
    0xed, 0x30, 0xed, 0x31, 0xed, 0x32, 0xed, 0x61, 0xed, 0x63,
    0xed, 0x65, 0xed, 0x69, 0xed, 0x6f, 0xed, 0x73, 0xed, 0x74};
const uint8_t HuffDecoderCommon::table42_3_emit_[4] = {0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table42_3_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table42_4_emit_[8] = {0xc0, 0xc1, 0xc8, 0xc9,
                                                       0xca, 0xcd, 0xd2, 0xd5};
const uint8_t HuffDecoderCommon::table42_4_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e};
const uint8_t HuffDecoderCommon::table42_5_emit_[9] = {
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint8_t HuffDecoderCommon::table42_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22};
const uint8_t HuffDecoderCommon::table42_6_emit_[16] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4,
    0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd};
const uint8_t HuffDecoderCommon::table42_6_ops_[64] = {
    0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01,
    0x0a, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01,
    0x01, 0x16, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01,
    0x01, 0x01, 0x22, 0x01, 0x01, 0x01, 0x26, 0x01, 0x01, 0x01, 0x2a,
    0x01, 0x01, 0x01, 0x2e, 0x01, 0x01, 0x01, 0x32, 0x01, 0x01, 0x01,
    0x36, 0x01, 0x01, 0x01, 0x3a, 0x01, 0x01, 0x01, 0x3e};
const uint8_t HuffDecoderCommon::table42_7_emit_[30] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c,
    0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table42_7_ops_[64] = {
    0x01, 0x01, 0x01, 0x02, 0x01, 0x06, 0x01, 0x0a, 0x01, 0x0e, 0x01,
    0x12, 0x01, 0x16, 0x01, 0x1a, 0x01, 0x1e, 0x01, 0x22, 0x01, 0x26,
    0x01, 0x2a, 0x01, 0x2e, 0x01, 0x32, 0x01, 0x36, 0x01, 0x3a, 0x01,
    0x3e, 0x01, 0x42, 0x01, 0x46, 0x01, 0x4a, 0x01, 0x4e, 0x01, 0x52,
    0x01, 0x56, 0x01, 0x5a, 0x01, 0x5e, 0x01, 0x62, 0x01, 0x66, 0x01,
    0x6a, 0x01, 0x6e, 0x01, 0x72, 0x01, 0x76, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table42_emit_[8] = {
    table42_0_emit_, table42_1_emit_, table42_2_emit_, table42_3_emit_,
    table42_4_emit_, table42_5_emit_, table42_6_emit_, table42_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table42_ops_[8] = {
    table42_0_ops_, table42_0_ops_, table42_0_ops_, table42_3_ops_,
    table42_4_ops_, table42_5_ops_, table42_6_ops_, table42_7_ops_,
};
const uint8_t HuffDecoderCommon::table36_0_emit_[1] = {0xab};
const uint16_t HuffDecoderCommon::table36_0_ops_[64] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table36_1_emit_[1] = {0xce};
const uint8_t HuffDecoderCommon::table36_2_emit_[1] = {0xd7};
const uint8_t HuffDecoderCommon::table36_3_emit_[1] = {0xe1};
const uint8_t HuffDecoderCommon::table36_4_emit_[1] = {0xec};
const uint8_t HuffDecoderCommon::table36_5_emit_[1] = {0xed};
const uint8_t HuffDecoderCommon::table36_6_emit_[2] = {0xc7, 0xcf};
const uint16_t HuffDecoderCommon::table36_6_ops_[64] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025};
const uint8_t HuffDecoderCommon::table36_7_emit_[2] = {0xea, 0xeb};
const uint8_t HuffDecoderCommon::table36_8_emit_[4] = {0xc0, 0xc1, 0xc8, 0xc9};
const uint16_t HuffDecoderCommon::table36_8_ops_[64] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
    0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066};
const uint8_t HuffDecoderCommon::table36_9_emit_[4] = {0xca, 0xcd, 0xd2, 0xd5};
const uint8_t HuffDecoderCommon::table36_10_emit_[4] = {0xda, 0xdb, 0xee, 0xf0};
const uint8_t HuffDecoderCommon::table36_11_emit_[5] = {0xf2, 0xf3, 0xff, 0xcb,
                                                        0xcc};
const uint16_t HuffDecoderCommon::table36_11_ops_[64] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087};
const uint8_t HuffDecoderCommon::table36_12_emit_[8] = {0xd3, 0xd4, 0xd6, 0xdd,
                                                        0xde, 0xdf, 0xf1, 0xf4};
const uint16_t HuffDecoderCommon::table36_12_ops_[64] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
    0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
    0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
    0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7};
const uint8_t HuffDecoderCommon::table36_13_emit_[8] = {0xf5, 0xf6, 0xf7, 0xf8,
                                                        0xfa, 0xfb, 0xfc, 0xfd};
const uint8_t HuffDecoderCommon::table36_14_emit_[15] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12};
const uint16_t HuffDecoderCommon::table36_14_ops_[64] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0088, 0x0088, 0x0088, 0x0088,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
    0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x0108, 0x0108, 0x0108, 0x0108,
    0x0128, 0x0128, 0x0128, 0x0128, 0x0148, 0x0148, 0x0148, 0x0148,
    0x0168, 0x0168, 0x0168, 0x0168, 0x0188, 0x0188, 0x0188, 0x0188,
    0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01c8, 0x01c8, 0x01c8, 0x01c8};
const uint8_t HuffDecoderCommon::table36_15_emit_[18] = {
    0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c,
    0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table36_15_ops_[64] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0088, 0x0088, 0x0088, 0x0088, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
    0x0108, 0x0108, 0x0108, 0x0108, 0x0128, 0x0128, 0x0128, 0x0128,
    0x0148, 0x0148, 0x0148, 0x0148, 0x0168, 0x0168, 0x0168, 0x0168,
    0x0188, 0x0188, 0x0188, 0x0188, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
    0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01ea, 0x020a, 0x022a, 0x001a};
const uint8_t* const HuffDecoderCommon::table36_emit_[16] = {
    table36_0_emit_,  table36_1_emit_,  table36_2_emit_,  table36_3_emit_,
    table36_4_emit_,  table36_5_emit_,  table36_6_emit_,  table36_7_emit_,
    table36_8_emit_,  table36_9_emit_,  table36_10_emit_, table36_11_emit_,
    table36_12_emit_, table36_13_emit_, table36_14_emit_, table36_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table36_ops_[16] = {
    table36_0_ops_,  table36_0_ops_,  table36_0_ops_,  table36_0_ops_,
    table36_0_ops_,  table36_0_ops_,  table36_6_ops_,  table36_6_ops_,
    table36_8_ops_,  table36_8_ops_,  table36_8_ops_,  table36_11_ops_,
    table36_12_ops_, table36_12_ops_, table36_14_ops_, table36_15_ops_,
};
}  // namespace geometry_8_12_10
}  // namespace grpc_core
