/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.tests.java.sql;

import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.harmony.testframework.serialization.SerializationTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimestampTest
extends TestCase {
    static long TIME_TEST1 = 38720231L;
    static long TIME_TEST2 = 80279000L;
    static long TIME_TEST3 = -38720691L;
    static long TIME_COMPARE = 123498845L;
    static long TIME_EARLY = -2347889122L;
    static long TIME_LATE = 2347889122L;
    static String STRING_TEST1 = "1970-01-01 10:45:20.231";
    static String STRING_TEST2 = "1970-01-01 22:17:59.0";
    static String STRING_TEST3 = "1969-12-31 13:14:39.309";
    static String STRING_INVALID1 = "ABCDEFGHI";
    static String STRING_INVALID2 = "233104";
    static String STRING_INVALID3 = "21-43-48";
    static String STRING_OUTRANGE = "2999-15-99 35:99:66.875";
    static long[] TIME_ARRAY = new long[]{TIME_TEST1, TIME_TEST2, TIME_TEST3};
    static int[] YEAR_ARRAY = new int[]{70, 70, 69};
    static int[] MONTH_ARRAY;
    static int[] DATE_ARRAY;
    static int[] HOURS_ARRAY;
    static int[] MINUTES_ARRAY;
    static int[] SECONDS_ARRAY;
    static int[] NANOS_ARRAY;
    static int[] NANOS_ARRAY2;
    static String[] STRING_NANOS_ARRAY;
    static String[] STRING_GMT_ARRAY;
    static String[] STRING_LA_ARRAY;
    static String[] STRING_JP_ARRAY;
    static String[] INVALID_STRINGS;
    static String TZ_LONDON;
    static String TZ_PACIFIC;
    static String TZ_JAPAN;
    static String[] TIMEZONES;
    static String[][] STRING_ARRAYS;
    static String theExceptionMessage;

    static {
        int[] nArray = new int[3];
        nArray[2] = 11;
        MONTH_ARRAY = nArray;
        DATE_ARRAY = new int[]{1, 1, 31};
        HOURS_ARRAY = new int[]{10, 22, 13};
        MINUTES_ARRAY = new int[]{45, 17, 14};
        SECONDS_ARRAY = new int[]{20, 59, 39};
        int[] nArray2 = new int[3];
        nArray2[0] = 231000000;
        nArray2[2] = 309000000;
        NANOS_ARRAY = nArray2;
        NANOS_ARRAY2 = new int[]{137891990, 635665198, 109985421};
        STRING_NANOS_ARRAY = new String[]{"1970-01-01 10:45:20.13789199", "1970-01-01 22:17:59.635665198", "1969-12-31 13:14:39.109985421"};
        STRING_GMT_ARRAY = new String[]{STRING_TEST1, STRING_TEST2, STRING_TEST3};
        STRING_LA_ARRAY = new String[]{"02:45:20", "14:17:59", "05:14:40"};
        STRING_JP_ARRAY = new String[]{"19:45:20", "07:17:59", "22:14:40"};
        INVALID_STRINGS = new String[]{STRING_INVALID1, STRING_INVALID2, STRING_INVALID3};
        TZ_LONDON = "GMT";
        TZ_PACIFIC = "America/Los_Angeles";
        TZ_JAPAN = "Asia/Tokyo";
        TIMEZONES = new String[]{TZ_LONDON, TZ_PACIFIC, TZ_JAPAN};
        STRING_ARRAYS = new String[][]{STRING_GMT_ARRAY, STRING_LA_ARRAY, STRING_JP_ARRAY};
        theExceptionMessage = "Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
    }

    public void testTimestamplong() {
        Timestamp timestamp = new Timestamp(TIME_TEST1);
        TimestampTest.assertNotNull((Object)timestamp);
    }

    public void testTimestampintintintintintintint() {
        Object object;
        Object object2;
        int[][] nArrayArray;
        int[][] nArrayArray2 = new int[14][];
        nArrayArray2[0] = new int[]{99, 2, 14, 17, 52, 3, 213577212};
        int[] nArray = new int[7];
        nArray[2] = 1;
        nArrayArray2[1] = nArray;
        nArrayArray2[2] = new int[]{106, 11, 31, 23, 59, 59, 999999999};
        nArrayArray2[3] = new int[]{106, 11, 31, 23, 59, 61, 999999999};
        nArrayArray2[4] = new int[]{106, 11, 31, 23, 59, -1, 999999999};
        nArrayArray2[5] = new int[]{106, 11, 31, 23, 61, 59, 999999999};
        nArrayArray2[6] = new int[]{106, 11, 31, 23, -1, 59, 999999999};
        nArrayArray2[7] = new int[]{106, 11, 31, 25, 59, 59, 999999999};
        nArrayArray2[8] = new int[]{106, 11, 31, -1, 59, 59, 999999999};
        nArrayArray2[9] = new int[]{106, 11, 35, 23, 59, 59, 999999999};
        nArrayArray2[10] = new int[]{106, 11, -1, 23, 59, 59, 999999999};
        nArrayArray2[11] = new int[]{106, 15, 31, 23, 59, 59, 999999999};
        nArrayArray2[12] = new int[]{106, -1, 31, 23, 59, 59, 999999999};
        nArrayArray2[13] = new int[]{-10, 11, 31, 23, 59, 59, 999999999};
        int[][] nArrayArray3 = nArrayArray = nArrayArray2;
        int n = 0;
        int n2 = nArrayArray3.length;
        while (n < n2) {
            object2 = nArrayArray3[n];
            object = new Timestamp(object2[0], object2[1], object2[2], object2[3], object2[4], object2[5], object2[6]);
            TimestampTest.assertNotNull((String)"Timestamp not generated: ", (Object)object);
            ++n;
        }
        object2 = new int[][]{{106, 11, 31, 23, 59, 59, 1999999999}, {106, 11, 31, 23, 59, 59, -999999999}};
        object = object2;
        n2 = 0;
        int n3 = ((Object)object).length;
        while (n2 < n3) {
            Object object3 = object[n2];
            try {
                new Timestamp((int)object3[0], (int)object3[1], (int)object3[2], (int)object3[3], (int)object3[4], (int)object3[5], (int)object3[6]);
                TimestampTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void testSetTimelong() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Timestamp timestamp = new Timestamp(TIME_TEST1);
        int n = 0;
        while (n < TIME_ARRAY.length) {
            timestamp.setTime(TIME_ARRAY[n]);
            TimestampTest.assertEquals((long)TIME_ARRAY[n], (long)timestamp.getTime());
            TimestampTest.assertEquals((int)NANOS_ARRAY[n], (int)timestamp.getNanos());
            ++n;
        }
    }

    public void testGetTime() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            Timestamp timestamp = new Timestamp(l);
            TimestampTest.assertEquals((long)l, (long)timestamp.getTime());
            ++n;
        }
    }

    public void testGetYear() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)YEAR_ARRAY[n], (int)timestamp.getYear());
            ++n;
        }
    }

    public void testGetMonth() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)MONTH_ARRAY[n], (int)timestamp.getMonth());
            ++n;
        }
    }

    public void testGetDate() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)DATE_ARRAY[n], (int)timestamp.getDate());
            ++n;
        }
    }

    public void testGetHours() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)HOURS_ARRAY[n], (int)timestamp.getHours());
            ++n;
        }
    }

    public void testGetMinutes() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)MINUTES_ARRAY[n], (int)timestamp.getMinutes());
            ++n;
        }
    }

    public void testGetSeconds() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)SECONDS_ARRAY[n], (int)timestamp.getSeconds());
            ++n;
        }
    }

    public void testValueOfString() {
        Object object;
        int n = 0;
        while (n < TIME_ARRAY.length) {
            object = new Timestamp(TIME_ARRAY[n]);
            Timestamp timestamp = Timestamp.valueOf(STRING_GMT_ARRAY[n]);
            TimestampTest.assertEquals((Object)object, (Object)timestamp);
            ++n;
        }
        Timestamp timestamp = Timestamp.valueOf(STRING_OUTRANGE);
        TimestampTest.assertNotNull((Object)timestamp);
        String[] stringArray = INVALID_STRINGS;
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            object = stringArray[n2];
            try {
                Timestamp.valueOf((String)object);
                TimestampTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void testValueOfString1() {
        Timestamp timestamp;
        long[] lArray = new long[]{38720231L, 38720231L, 80279000L, -38720691L, 38720000L};
        int[] nArray = new int[5];
        nArray[0] = 231000000;
        nArray[1] = 231987654;
        nArray[3] = 309000000;
        int[] nArray2 = nArray;
        String[] stringArray = new String[]{"1970-01-01 10:45:20.231", "1970-01-01 10:45:20.231987654", "1970-01-01 22:17:59.0", "1969-12-31 13:14:39.309", "1970-01-01 10:45:20"};
        String[] stringArray2 = new String[9];
        stringArray2[1] = "ABCDEFGHI";
        stringArray2[2] = "233104";
        stringArray2[3] = "1970-01-01 22:17:59.";
        stringArray2[4] = "1970-01-01 10:45:20.231987654690645322";
        stringArray2[5] = "1970-01-01 10:45:20&231987654";
        stringArray2[6] = "1970-01-01 10:45:20.-31987654";
        stringArray2[7] = "1970-01-01 10:45:20.ABCD87654";
        stringArray2[8] = "21-43-48";
        String[] stringArray3 = stringArray2;
        int n = 0;
        while (n < stringArray.length) {
            timestamp = Timestamp.valueOf(stringArray[n]);
            TimestampTest.assertEquals((long)lArray[n], (long)timestamp.getTime());
            TimestampTest.assertEquals((int)nArray2[n], (int)timestamp.getNanos());
            ++n;
        }
        String[] stringArray4 = stringArray3;
        int n2 = 0;
        int n3 = stringArray4.length;
        while (n2 < n3) {
            String string = stringArray4[n2];
            try {
                timestamp = Timestamp.valueOf(string);
                TimestampTest.fail((String)"Should throw IllegalArgumentException.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void testToString() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((String)STRING_GMT_ARRAY[n], (String)timestamp.toString());
            ++n;
        }
    }

    public void testGetNanos() {
        int n = 0;
        while (n < TIME_ARRAY.length) {
            Timestamp timestamp = new Timestamp(TIME_ARRAY[n]);
            TimestampTest.assertEquals((int)NANOS_ARRAY[n], (int)timestamp.getNanos());
            ++n;
        }
    }

    public void testSetNanosint() {
        Timestamp timestamp;
        int[] nArray = new int[]{-137891990, 1635665198, -1};
        int n = 0;
        while (n < TIME_ARRAY.length) {
            timestamp = new Timestamp(TIME_ARRAY[n]);
            timestamp.setNanos(NANOS_ARRAY2[n]);
            TimestampTest.assertEquals((int)NANOS_ARRAY2[n], (int)timestamp.getNanos());
            TimestampTest.assertEquals((String)STRING_NANOS_ARRAY[n], (String)timestamp.toString());
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            timestamp = new Timestamp(TIME_ARRAY[n]);
            int n2 = timestamp.getNanos();
            try {
                timestamp.setNanos(nArray[n]);
                TimestampTest.fail((String)"Should throw IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            TimestampTest.assertEquals((int)n2, (int)timestamp.getNanos());
            ++n;
        }
    }

    public void testEqualsTimestamp() {
        Timestamp timestamp;
        Object object;
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            object = new Timestamp(l);
            timestamp = new Timestamp(l);
            TimestampTest.assertTrue((boolean)((Timestamp)object).equals(timestamp));
            ++n;
        }
        Timestamp timestamp2 = new Timestamp(TIME_COMPARE);
        object = TIME_ARRAY;
        n2 = 0;
        int n3 = ((long[])object).length;
        while (n2 < n3) {
            Object object2 = object[n2];
            timestamp = new Timestamp((long)object2);
            TimestampTest.assertFalse((boolean)timestamp.equals(timestamp2));
            ++n2;
        }
        TimestampTest.assertFalse((boolean)new Timestamp(0L).equals(null));
    }

    public void testEqualsObject() {
        Timestamp timestamp;
        Object object;
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            object = new Timestamp(l);
            timestamp = new Timestamp(l);
            TimestampTest.assertTrue((boolean)((Timestamp)object).equals((Object)timestamp));
            ++n;
        }
        Timestamp timestamp2 = new Timestamp(TIME_COMPARE);
        object = TIME_ARRAY;
        n2 = 0;
        int n3 = ((long[])object).length;
        while (n2 < n3) {
            Object object2 = object[n2];
            timestamp = new Timestamp((long)object2);
            TimestampTest.assertFalse((boolean)timestamp.equals((Object)timestamp2));
            ++n2;
        }
        String string = new String("Test ");
        Timestamp timestamp3 = new Timestamp(TIME_ARRAY[1]);
        TimestampTest.assertFalse((boolean)timestamp3.equals(string));
        TimestampTest.assertFalse((boolean)new Timestamp(0L).equals((Object)null));
    }

    public void testBeforeTimestamp() {
        Timestamp timestamp;
        long l;
        Timestamp timestamp2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp = new Timestamp(l);
            TimestampTest.assertTrue((boolean)timestamp.before(timestamp2));
            ++n;
        }
        timestamp2 = new Timestamp(TIME_EARLY);
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp = new Timestamp(l);
            TimestampTest.assertFalse((boolean)timestamp.before(timestamp2));
            ++n;
        }
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp2 = new Timestamp(l);
            timestamp = new Timestamp(l);
            TimestampTest.assertFalse((boolean)timestamp.before(timestamp2));
            timestamp2.setNanos(timestamp2.getNanos() + 1);
            TimestampTest.assertTrue((boolean)timestamp.before(timestamp2));
            ++n;
        }
    }

    public void testAfterTimestamp() {
        Timestamp timestamp;
        long l;
        Timestamp timestamp2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp = new Timestamp(l);
            TimestampTest.assertFalse((boolean)timestamp.after(timestamp2));
            ++n;
        }
        timestamp2 = new Timestamp(TIME_EARLY);
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp = new Timestamp(l);
            TimestampTest.assertTrue((boolean)timestamp.after(timestamp2));
            ++n;
        }
        lArray = TIME_ARRAY;
        n = 0;
        n2 = lArray.length;
        while (n < n2) {
            l = lArray[n];
            timestamp2 = new Timestamp(l);
            timestamp = new Timestamp(l);
            TimestampTest.assertFalse((boolean)timestamp.after(timestamp2));
            timestamp.setNanos(timestamp.getNanos() + 1);
            TimestampTest.assertTrue((boolean)timestamp.after(timestamp2));
            ++n;
        }
    }

    public void testCompareToTimestamp() {
        Timestamp timestamp = new Timestamp(TIME_EARLY);
        Timestamp timestamp2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            Timestamp timestamp3 = new Timestamp(l);
            Timestamp timestamp4 = new Timestamp(l);
            TimestampTest.assertTrue((timestamp3.compareTo(timestamp) > 0 ? 1 : 0) != 0);
            TimestampTest.assertTrue((timestamp3.compareTo(timestamp2) < 0 ? 1 : 0) != 0);
            TimestampTest.assertEquals((int)0, (int)timestamp3.compareTo(timestamp4));
            ++n;
        }
        Timestamp timestamp5 = new Timestamp(-1L);
        Timestamp timestamp6 = new Timestamp(-1L);
        timestamp5.setTime(Long.MIN_VALUE);
        timestamp6.setDate(Integer.MIN_VALUE);
        TimestampTest.assertEquals((int)1, (int)timestamp5.compareTo(timestamp6));
        TimestampTest.assertEquals((int)-1, (int)timestamp6.compareTo(timestamp5));
        timestamp5.setTime(Long.MAX_VALUE);
        timestamp6.setTime(0x7FFFFFFFFFFFFFFEL);
        TimestampTest.assertEquals((int)1, (int)timestamp5.compareTo(timestamp6));
        TimestampTest.assertEquals((int)-1, (int)timestamp6.compareTo(timestamp5));
        timestamp5.setTime(Integer.MAX_VALUE);
        timestamp6.setTime(Integer.MAX_VALUE);
        TimestampTest.assertEquals((int)0, (int)timestamp5.compareTo(timestamp6));
        TimestampTest.assertEquals((int)0, (int)timestamp6.compareTo(timestamp5));
    }

    public void testCompareToDate() {
        Timestamp timestamp = new Timestamp(TIME_EARLY);
        Timestamp timestamp2 = new Timestamp(TIME_LATE);
        long[] lArray = TIME_ARRAY;
        int n = 0;
        int n2 = lArray.length;
        while (n < n2) {
            long l = lArray[n];
            Timestamp timestamp3 = new Timestamp(l);
            Timestamp timestamp4 = new Timestamp(l);
            TimestampTest.assertTrue((timestamp3.compareTo((Date)timestamp) > 0 ? 1 : 0) != 0);
            TimestampTest.assertTrue((timestamp3.compareTo((Date)timestamp2) < 0 ? 1 : 0) != 0);
            TimestampTest.assertEquals((int)0, (int)timestamp3.compareTo((Date)timestamp4));
            ++n;
        }
        Date date = new Date();
        Timestamp timestamp5 = new Timestamp(TIME_ARRAY[1]);
        try {
            timestamp5.compareTo(date);
            TimestampTest.fail((String)"testCompareToObject: Did not get expected ClassCastException");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testSerializationSelf() throws Exception {
        Timestamp timestamp = new Timestamp(100L);
        SerializationTest.verifySelf((Object)timestamp);
    }

    public void testSerializationCompatibility() throws Exception {
        Timestamp timestamp = new Timestamp(100L);
        SerializationTest.verifyGolden((TestCase)this, (Object)timestamp);
    }

    public void test_toString() {
        Timestamp timestamp = new Timestamp(Long.MIN_VALUE);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.192", (String)timestamp.toString());
        Timestamp timestamp2 = new Timestamp(-9223372036854775807L);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.193", (String)timestamp2.toString());
        Timestamp timestamp3 = new Timestamp(-9223372036854775001L);
        TimestampTest.assertEquals((String)"292278994-08-17 07:12:55.999", (String)timestamp3.toString());
        Timestamp timestamp4 = new Timestamp(-9223372036854775000L);
        TimestampTest.assertEquals((String)"292269055-12-02 16:47:05.0", (String)timestamp4.toString());
    }
}

