// ENG1_QM_MOPAC.H : the MOPAC engine.

// Copyright (C) 2001 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef ENG1_QM_MOPAC_H
#define ENG1_QM_MOPAC_H

#ifdef ENABLE_MOPAC7

class eng1_qm_mopac;

/*################################################################################################*/

#include "eng1_qm.h"

/*################################################################################################*/

class eng1_qm_mopac : public eng1_qm
{
	private:
	
	static eng1_qm_mopac * mopac_lock;
	
	protected:
	
	public:
	
	eng1_qm_mopac(setup *, i32u, i32u);
	~eng1_qm_mopac(void);
	
	void FixMeLaterTSS(void);
	
	static eng1_qm_mopac * GetLock(void) { return mopac_lock; }
	
	i32s GetOrbitalCount(void);		// virtual
	f64 GetOrbitalEnergy(i32s);		// virtual
	
	i32s GetElectronCount(void);		// virtual
	
	void Compute(i32u, bool = false);	// virtual
	
	void SetupPlotting(void);		// virtual
	
	fGL GetESP(fGL *, fGL *);		// virtual
	
	fGL GetElDens(fGL *, fGL *);		// virtual
	
	fGL GetOrbital(fGL *, fGL *);		// virtual
	fGL GetOrbDens(fGL *, fGL *);		// virtual
};

/*################################################################################################*/

#endif	// ENABLE_MOPAC7
#endif	// ENG1_QM_MOPAC_H

// eof
